/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.item;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import xfacthd.framedblocks.api.block.FramedBlockEntity;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.blueprint.BlueprintCopyBehaviour;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.data.FramedToolType;
import xfacthd.framedblocks.common.item.FramedToolItem;
import xfacthd.framedblocks.common.util.ServerConfig;

public class FramedBlueprintItem
extends FramedToolItem {
    public static final String CONTAINED_BLOCK = "desc.framed_blocks:blueprint_block";
    public static final String CAMO_BLOCK = "desc.framed_blocks:blueprint_camo";
    public static final String IS_ILLUMINATED = "desc.framed_blocks:blueprint_illuminated";
    public static final MutableComponent BLOCK_NONE = new TranslatableComponent("desc.framed_blocks:blueprint_none").m_130940_(ChatFormatting.RED);
    public static final MutableComponent BLOCK_INVALID = new TranslatableComponent("desc.framed_blocks:blueprint_invalid").m_130940_(ChatFormatting.RED);
    public static final MutableComponent ILLUMINATED_FALSE = new TranslatableComponent("desc.framed_blocks:blueprint_illuminated_false").m_130940_(ChatFormatting.RED);
    public static final MutableComponent ILLUMINATED_TRUE = new TranslatableComponent("desc.framed_blocks:blueprint_illuminated_true").m_130940_(ChatFormatting.GREEN);
    public static final MutableComponent CANT_COPY = new TranslatableComponent("desc.framed_blocks:blueprint_cant_copy").m_130940_(ChatFormatting.RED);
    public static final Component CANT_PLACE_FLUID_CAMO = Utils.translate("desc", "blueprint_cant_place_fluid_camo").m_130940_(ChatFormatting.RED);
    private static final Map<Block, BlueprintCopyBehaviour> COPY_BEHAVIOURS = new IdentityHashMap<Block, BlueprintCopyBehaviour>();
    private static final BlueprintCopyBehaviour NO_OP_BEHAVIOUR = new BlueprintCopyBehaviour(){};

    public FramedBlueprintItem(FramedToolType type) {
        super(type);
    }

    @Override
    public boolean doesSneakBypassUse(ItemStack stack, LevelReader level, BlockPos pos, Player player) {
        return false;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player.m_6144_()) {
            if (!level.m_5776_()) {
                CompoundTag tag = stack.m_41698_("blueprint_data");
                tag.m_128473_("framed_block");
                tag.m_128473_("camo_data");
                tag.m_128473_("camo_data_two");
            }
            return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.m_5776_());
        }
        return super.m_7203_(level, player, hand);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        CompoundTag tag = context.m_43722_().m_41698_("blueprint_data");
        if (player.m_6144_()) {
            return FramedBlueprintItem.writeBlueprint(level, pos, tag);
        }
        if (!tag.m_128456_()) {
            return FramedBlueprintItem.readBlueprint(context, player, tag);
        }
        return super.m_6225_(context);
    }

    private static InteractionResult writeBlueprint(Level level, BlockPos pos, CompoundTag tag) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof FramedBlockEntity)) {
            return InteractionResult.FAIL;
        }
        FramedBlockEntity be = (FramedBlockEntity)blockEntity;
        if (!level.m_5776_()) {
            BlockState state = level.m_8055_(pos);
            String blockName = ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)state.m_60734_()).toString();
            tag.m_128359_("framed_block", blockName);
            Block block = state.m_60734_();
            if (!FramedBlueprintItem.getBehaviour(block).writeToBlueprint(level, pos, state, be, tag)) {
                tag.m_128365_("camo_data", (Tag)be.writeToBlueprint());
            }
        }
        return InteractionResult.m_19078_((boolean)level.m_5776_());
    }

    private static InteractionResult readBlueprint(UseOnContext context, Player player, CompoundTag tag) {
        Block block = FramedBlueprintItem.getTargetBlock(context.m_43722_());
        if (block.m_49966_().m_60795_()) {
            return InteractionResult.FAIL;
        }
        Item item = block.m_5456_();
        if (!(item instanceof BlockItem)) {
            return InteractionResult.FAIL;
        }
        BlockItem blockItem = (BlockItem)item;
        if (FramedBlueprintItem.checkMissingMaterials(player, blockItem, tag)) {
            return InteractionResult.FAIL;
        }
        return FramedBlueprintItem.tryPlace(context, player, blockItem, tag);
    }

    private static boolean checkMissingMaterials(Player player, BlockItem item, CompoundTag tag) {
        int intangible;
        if (player.m_150110_().f_35937_) {
            return false;
        }
        Set<Pair<BlockState, ItemStack>> camos = FramedBlueprintItem.getCamos(item, tag);
        if (camos.stream().anyMatch(FramedBlueprintItem::isFluidCamo)) {
            player.m_5661_(CANT_PLACE_FLUID_CAMO, false);
            return true;
        }
        ArrayList<ItemStack> materials = new ArrayList<ItemStack>();
        materials.add(FramedBlueprintItem.getBlockItem(item));
        materials.addAll(FramedBlueprintItem.getCamoStacksMerged(camos));
        int glowstone = FramedBlueprintItem.getBehaviour(item.m_40614_()).getGlowstoneCount(tag);
        if (glowstone > 0) {
            materials.add(new ItemStack((ItemLike)Items.f_42525_, glowstone));
        }
        if ((intangible = FramedBlueprintItem.getBehaviour(item.m_40614_()).getIntangibleCount(tag)) > 0) {
            materials.add(new ItemStack((ItemLike)ServerConfig.intangibleMarkerItem, glowstone));
        }
        for (ItemStack stack : materials) {
            if (stack.m_41619_() || player.m_150109_().m_18947_(stack.m_41720_()) >= stack.m_41613_()) continue;
            return true;
        }
        return false;
    }

    private static InteractionResult tryPlace(UseOnContext context, Player player, BlockItem item, CompoundTag tag) {
        ItemStack dummyStack = new ItemStack((ItemLike)item, 1);
        dummyStack.m_41784_().m_128365_("BlockEntityTag", (Tag)tag.m_128469_("camo_data").m_6426_());
        UseOnContext placeContext = new UseOnContext(context.m_43725_(), context.m_43723_(), context.m_43724_(), dummyStack, new BlockHitResult(context.m_43720_(), context.m_43719_(), context.m_8083_(), context.m_43721_()));
        BlockPos pos = new BlockPlaceContext(placeContext).m_8083_();
        InteractionResult result = item.m_6225_(placeContext);
        if (!context.m_43725_().m_5776_() && result.m_19077_()) {
            FramedBlueprintItem.getBehaviour(item.m_40614_()).postProcessPaste(context.m_43725_(), pos, context.m_43723_(), tag, dummyStack);
            if (!player.m_150110_().f_35937_) {
                FramedBlueprintItem.consumeItems(player, item, tag);
            }
        }
        return result;
    }

    private static void consumeItems(Player player, BlockItem item, CompoundTag tag) {
        int intangible;
        Set<Pair<BlockState, ItemStack>> camos = FramedBlueprintItem.getCamos(item, tag);
        if (camos.stream().anyMatch(FramedBlueprintItem::isFluidCamo)) {
            return;
        }
        ArrayList<ItemStack> materials = new ArrayList<ItemStack>();
        materials.add(FramedBlueprintItem.getBlockItem(item));
        materials.addAll(FramedBlueprintItem.getCamoStacksMerged(camos));
        int glowstone = FramedBlueprintItem.getBehaviour(item.m_40614_()).getGlowstoneCount(tag);
        if (glowstone > 0) {
            materials.add(new ItemStack((ItemLike)Items.f_42525_, glowstone));
        }
        if ((intangible = FramedBlueprintItem.getBehaviour(item.m_40614_()).getIntangibleCount(tag)) > 0) {
            materials.add(new ItemStack((ItemLike)ServerConfig.intangibleMarkerItem, glowstone));
        }
        Inventory inv = player.m_150109_();
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            for (ItemStack material : materials) {
                if (material.m_41619_() || !stack.m_150930_(material.m_41720_())) continue;
                int size = stack.m_41613_();
                stack.m_41774_(Math.min(material.m_41613_(), size));
                material.m_41774_(size - stack.m_41613_());
                inv.m_6596_();
            }
            materials.removeIf(ItemStack::m_41619_);
            if (materials.isEmpty()) break;
        }
    }

    private static BlueprintCopyBehaviour getBehaviour(Block block) {
        return COPY_BEHAVIOURS.getOrDefault(block, NO_OP_BEHAVIOUR);
    }

    public static Set<Pair<BlockState, ItemStack>> getCamos(BlockItem item, CompoundTag tag) {
        return FramedBlueprintItem.getBehaviour(item.m_40614_()).getCamos(tag).orElseGet(() -> Set.of(Pair.of((Object)NbtUtils.m_129241_((CompoundTag)tag.m_128469_("camo_data").m_128469_("camo_state")), (Object)ItemStack.m_41712_((CompoundTag)tag.m_128469_("camo_data").m_128469_("camo_stack")))));
    }

    private static ItemStack getBlockItem(BlockItem item) {
        return FramedBlueprintItem.getBehaviour(item.m_40614_()).getBlockItem().orElse(new ItemStack((ItemLike)item));
    }

    private static List<ItemStack> getCamoStacksMerged(Set<Pair<BlockState, ItemStack>> camos) {
        ArrayList<ItemStack> camoStacks = new ArrayList<ItemStack>();
        for (Pair<BlockState, ItemStack> camo : camos) {
            ItemStack stack = (ItemStack)camo.getSecond();
            if (stack.m_41619_()) continue;
            for (ItemStack existing : camoStacks) {
                if (!ItemStack.m_41746_((ItemStack)existing, (ItemStack)stack)) continue;
                int size = existing.m_41613_();
                existing.m_41769_(Math.max(existing.m_41741_() - size, stack.m_41613_()));
                stack.m_41774_(existing.m_41613_() - size);
                if (!stack.m_41619_()) continue;
                break;
            }
            if (stack.m_41619_()) continue;
            camoStacks.add(stack);
        }
        return camoStacks;
    }

    private static boolean isFluidCamo(Pair<BlockState, ItemStack> camo) {
        return ((BlockState)camo.getFirst()).m_60734_() instanceof LiquidBlock;
    }

    public static Block getTargetBlock(ItemStack stack) {
        CompoundTag tag = stack.m_41698_("blueprint_data");
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(tag.m_128461_("framed_block")));
        Objects.requireNonNull(block);
        return block;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> components, TooltipFlag flag) {
        CompoundTag tag = stack.m_41698_("blueprint_data");
        if (tag.m_128456_()) {
            components.add((Component)new TranslatableComponent(CONTAINED_BLOCK, new Object[]{BLOCK_NONE}).m_130940_(ChatFormatting.GOLD));
        } else {
            MutableComponent mutableComponent;
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(tag.m_128461_("framed_block")));
            MutableComponent blockName = block == null ? BLOCK_INVALID : block.m_49954_().m_130940_(ChatFormatting.WHITE);
            CompoundTag beTag = tag.m_128469_("camo_data");
            if (!(block instanceof IFramedBlock)) {
                mutableComponent = BLOCK_NONE;
            } else {
                IFramedBlock fb = (IFramedBlock)block;
                mutableComponent = (Component)fb.printCamoBlock(beTag).orElse(BLOCK_NONE);
            }
            MutableComponent camoName = mutableComponent;
            MutableComponent illuminated = beTag.m_128471_("glowing") ? ILLUMINATED_TRUE : ILLUMINATED_FALSE;
            MutableComponent lineOne = new TranslatableComponent(CONTAINED_BLOCK, new Object[]{blockName}).m_130940_(ChatFormatting.GOLD);
            MutableComponent lineTwo = new TranslatableComponent(CAMO_BLOCK, new Object[]{camoName}).m_130940_(ChatFormatting.GOLD);
            MutableComponent lineThree = new TranslatableComponent(IS_ILLUMINATED, new Object[]{illuminated}).m_130940_(ChatFormatting.GOLD);
            components.addAll(Arrays.asList(lineOne, lineTwo, lineThree));
        }
    }

    public static synchronized void registerBehaviour(BlueprintCopyBehaviour behaviour, Block ... blocks) {
        Preconditions.checkNotNull((Object)behaviour, (Object)"BlueprintCopyBehaviour must be non-null");
        Preconditions.checkNotNull((Object)blocks, (Object)"Blocks array must be non-null to register a BlueprintCopyBehaviour");
        Preconditions.checkState((blocks.length > 0 ? 1 : 0) != 0, (Object)"At least one block must be provided to register a BlueprintCopyBehaviour");
        for (Block block : blocks) {
            COPY_BEHAVIOURS.put(block, behaviour);
        }
    }
}

